{*
 * Projecte Fressa a LINKAT
 * GLOBUS3
 *
 * @author Jordi Lagares Roset "jlagares@xtec.cat - www.lagares.org"
 * amb el suport del Departament d'Educacio de la Generalitat de Catalunya
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details (see the LICENSE file).
 *}

unit UnitArcDeSantMarti;

{************************************************}
INTERFACE
{************************************************}

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Buttons, ExtCtrls, MMSystem;

type
  TFormArcDeSantMarti = class(TForm)
    Panel: TPanel;
    SpeedButtonEngegarParar: TSpeedButton;
    SpeedButtonCaixaEines: TSpeedButton;
    SpeedButtonCopiarALaCarpeta: TSpeedButton;
    procedure SpeedButtonEngegarPararClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure SpeedButtonCaixaEinesClick(Sender: TObject);
    procedure SpeedButtonCopiarALaCarpetaClick(Sender: TObject);
    procedure FormMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
  private
    { Private declarations }
    procedure WMWIMDATA(var Msg: TMessage); message MM_WIM_DATA;
  public
    { Public declarations }
  end;

var
  FormArcDeSantMarti: TFormArcDeSantMarti;

{************************************************}
IMPLEMENTATION
{************************************************}

uses UnitEntradaSo, RainBow, UnitCanviDeparametres, UnitTools;

{$R *.DFM}

procedure TFormArcDeSantMarti.FormClose(Sender: TObject;var Action: TCloseAction);
begin
  if not (SpeedButtonEngegarParar.Caption='E') then begin
    PararEntradaSo;
    FinalitzarEntradaSo;
    SpeedButtonEngegarParar.Caption:='E';
    SpeedButtonEngegarParar.Down:=false;
  end;
end;

procedure TFormArcDeSantMarti.SpeedButtonEngegarPararClick(Sender: TObject);
begin
  if SpeedButtonEngegarParar.Caption='E' then begin
    SpeedButtonEngegarParar.Caption:='P';
    RePaint;
    IniciarDadesUnitEntradaSo(512);
    EngegarProcesEntradaSo(Handle);
  end else begin
    PararEntradaSo;
    FinalitzarEntradaSo;
    SpeedButtonEngegarParar.Caption:='E';
  end;
end;

procedure TFormArcDeSantMarti.WMWIMDATA(var Msg: TMessage);
var
  i,Max:integer;
  R:TRect;
  PaintDC:HDC;
begin
  Max:=0;
  For i:=1 to BytesBuffer do if so[NumeroBufer,i]-127>Max then Max:=so[NumeroBufer,i]-127;
  if Max>ValorMinim then begin
    R:=GetClientRect;
    PaintDC:=GetDC(Handle);
    PaintRainbow(PaintDC,0,0,R.Right-R.Left,R.Bottom-R.Top,true,true);
    ReleaseDc(Handle,PaintDC);
  end else Repaint;
  EntradaSo;
end;

procedure TFormArcDeSantMarti.SpeedButtonCaixaEinesClick(Sender: TObject);
begin
  FormCanviDeParametres.ShowModal;
end;

procedure TFormArcDeSantMarti.SpeedButtonCopiarALaCarpetaClick(Sender: TObject);
var
  Rect:TRect;
begin
  Rect.Left:=0;
  Rect.Top:=Panel.Height;
  Rect.Right:=ClientRect.Right;
  Rect.Bottom:=ClientRect.Bottom;
  CopiarPartDeLaFinestraALaCarpeta(Handle,Rect);
end;

procedure TFormArcDeSantMarti.FormMouseDown(Sender: TObject;Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  if Button=mbleft then begin
  end else begin
    if not (SpeedButtonEngegarParar.Caption='E') then begin
      PararEntradaSo;
      FinalitzarEntradaSo;
      SpeedButtonEngegarParar.Caption:='E';
      SpeedButtonEngegarParar.Down:=false;
    end;
  end;
end;

end.
